<?php

function checkSuspiciousTransaction($transactionAmount, $userTransactionHistory, $transactionLocation, $userBehavior, $accountAccessFrequency) {
    $message = "Transaction is not suspicious."; // Default message

    // Unusually Large Transactions
    if ($transactionAmount > 2 * array_sum($userTransactionHistory)) {
        $message = "Transaction is unusually large.";
    }

    // Rapid Consecutive Large Transactions
    $recentTransactions = array_slice($userTransactionHistory, -3);
    if ($transactionAmount > array_sum($recentTransactions)) {
        $message = "Rapid consecutive large transactions detected.";
    }

    // Frequent Transactions Below Reporting Threshold
    $reportingThreshold = 1000; // Set your reporting threshold
    if ($transactionAmount < $reportingThreshold) {
        $message = "Frequent transactions below reporting threshold detected.";
    }

    // Unusual Transaction Patterns
    // Add conditions based on your specific patterns

    // Geographical Inconsistencies
    $highRiskLocations = ['CountryA', 'CountryB']; // Set high-risk locations
    if (in_array($transactionLocation, $highRiskLocations)) {
        $message = "Transaction originating from a high-risk geographical location.";
    }

    // Sudden Changes in Customer's Transaction Location
    // Add conditions based on your specific criteria

    // Drastic Changes in Customer's Transaction Behavior
    // Add conditions based on your specific criteria

    // Multiple Small Transactions to Bypass Limits
    $dailyTransactionLimit = 500; // Set your daily transaction limit
    if ($transactionAmount < $dailyTransactionLimit) {
        $message = "Multiple small transactions detected to bypass limits.";
    }

    // Round-Number Transactions
    if ($transactionAmount % 10 == 0) {
        $message = "Transaction involving a round number detected.";
    }

    // Unusual Hours of Operation
    $normalBusinessHours = [9, 17]; // Set your normal business hours
    $transactionHour = date('G'); // Get the current hour
    if (!in_array($transactionHour, $normalBusinessHours)) {
        $message = "Transaction occurring outside normal business hours.";
    }

    // Structured Transactions
    // Add conditions based on your specific criteria

    // Unusual Payment Methods
    $highRiskPaymentMethods = ['Bitcoin', 'Prepaid Cards']; // Set high-risk payment methods
    // Assuming $paymentMethod is the payment method used
    if (in_array($paymentMethod, $highRiskPaymentMethods)) {
        $message = "Unusual or high-risk payment method detected.";
    }

    // Frequent Changes in Payment Methods
    // Add conditions based on your specific criteria

    // Unusual Frequency of Account Access
    $normalAccessFrequency = 5; // Set your normal account access frequency
    if ($accountAccessFrequency > $normalAccessFrequency) {
        $message = "Abnormal frequency of account logins or access.";
    }

    // Unexplained Cross-Border Transactions
    $crossBorderCountries = ['CountryX', 'CountryY']; // Set cross-border countries
    if (in_array($transactionLocation, $crossBorderCountries)) {
        $message = "Unexplained cross-border transaction detected.";
    }

    // Incomplete or False Information
    // Add conditions based on your specific criteria

    // Rapid Movement of Funds
    $rapidMovementThreshold = 10000; // Set your rapid movement threshold
    if ($transactionAmount > $rapidMovementThreshold) {
        $message = "Rapid movement of funds detected.";
    }

    // Repeated Reversals or Chargebacks
    $chargebackThreshold = 3; // Set your chargeback threshold
    if ($numberOfChargebacks > $chargebackThreshold) {
        $message = "Frequent reversals or chargebacks detected.";
    }

    // Peer-to-Peer Transactions
    // Add conditions based on your specific criteria

    // Unusual User Behavior
    // Add conditions based on your specific criteria

    // Use of Anonymous Proxies or VPNs
    if ($isUsingVPN) {
        $message = "Use of anonymous proxies or VPNs detected.";
    }

    return $message;
}

// Example usage
$userTransactionHistory = [100, 200, 150];
$transactionAmount = 500;
$transactionLocation = 'CountryA';
$userBehavior = 'Normal'; // Add user behavior information based on your criteria
$accountAccessFrequency = 8; // Add account access frequency information based on your criteria
$paymentMethod = 'Bitcoin'; // Add payment method information based on your criteria
$numberOfChargebacks = 2; // Add the number of chargebacks information based on your criteria
$isUsingVPN = true; // Add VPN information based on your criteria

$result = checkSuspiciousTransaction($transactionAmount, $userTransactionHistory, $transactionLocation, $userBehavior, $accountAccessFrequency);
echo $result;

?>
