<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "ams";

// Create a connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
// Include the QR code library
include '../phpqrcode/qrlib.php';

// Sample data (replace these with your actual form data)
$fname = $_POST['fname'];
$lname = $_POST['lname'];
$full = $_POST['fname'].' '.$_POST['lname'];
$mtaa = $_POST['mtaa'];
$phone = $_POST['phone'];
$region = $_POST['region'];
$tin = $_POST['tin'];
$password = password_hash($_POST['password'], PASSWORD_BCRYPT); // Hash the password
$tc = $_POST['tc'];

// Generate a unique 8-digit code
$code = generateUniqueCode($conn);

// Function to generate QR code
function generateQRCode($data, $filename)
{
    // Specify the path to the qrcode folder
    $folderPath = '../wakala/qrcodes/';

    $size = 15;
    // QR code configuration
    $ecc = 'L'; // Error correction level (L, M, Q, H)

    // Generate QR code
    QRcode::png($data, $folderPath . $filename, $ecc, $size);

    echo "QR code generated and saved as $folderPath$filename";
}

// Example usage
$qrcode_line = $code;
$data = $qrcode_line.','.$full;
$filename = $qrcode_line .".png"; // Fix: concatenate the file extension

generateQRCode($data, $filename);

// SQL query with a prepared statement
$sql = "INSERT INTO agents (fname, lname, mtaa, phone, region, tin, password, tc, code, qr) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);

// Bind parameters
$stmt->bind_param("ssssssssss", $fname, $lname, $mtaa, $phone, $region, $tin, $password, $tc, $code, $filename);

// Execute the statement
if ($stmt->execute()) {
    echo "
        <script type='text/javascript'>
          window.location.href='../otp?phone_number=$phone';
        </script>
      ";
} else {
    echo "Error: " . $stmt->error;
}

// Close the statement and connection
$stmt->close();
$conn->close();

// Function to generate a unique 8-digit code
function generateUniqueCode($conn)
{
    $code = generateCode();

    // Check if the code already exists in the database
    $stmt = $conn->prepare("SELECT COUNT(*) FROM agents WHERE code = ?");
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();
    $stmt->close();

    // If the code exists, generate a new one
    if ($count > 0) {
        return generateUniqueCode($conn);
    }

    return $code;
}

// Function to generate an 8-digit code
function generateCode()
{
    return str_pad(mt_rand(1, 99999999), 8, '0', STR_PAD_LEFT);
}
?>
