<?php
session_start();
include '../db.php'; // Assuming you have a database connection file

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    // Redirect to the login page or any other appropriate action
    header("Location: ../login");
    exit();
}

// Logout functionality with updating the 'logged_out' column
if (isset($_GET['logout']) && $_GET['logout'] == 1) {
    // Update the 'logged_out' column in the administrators table
    $updateQuery = "UPDATE administrators SET logged_out = NOW() WHERE id = :user_id";

    $stmt = $pdo->prepare($updateQuery);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();

    // Unset all session variables
    $_SESSION = array();

    // Destroy the session
    session_destroy();

    // Redirect to the login page or any other appropriate action after logout
    header("Location: ../login");
    exit();
}
?>
