<?php
session_start();
require_once('db.php'); // Include your database connection script

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['email'];
    $password = $_POST['password'];

    // Validate inputs (add more validation as needed)

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Check user credentials
    $stmt = $pdo->prepare("SELECT id, name, passkey FROM administrators WHERE email = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['passkey'])) {
        // Successful login
        $_SESSION['id'] = $user['id'];
        header('Location: ../'); // Redirect to a secure page
        exit();
    } else {
        // Failed login
        echo 'Invalid username or password';
    }
}
?>
