
<?php
session_start();

// Check if the user is not logged in
if (!isset($_SESSION['id'])) {
    // Redirect to the login page or another appropriate action
    header('Location: ../login'); // Assuming "/login" is the correct path
    exit();
}

require_once('../db.php');

// Fetch user information based on the user_id stored in the session
$user_id = $_SESSION['id'];

// Use a prepared statement to retrieve user data
$stmt = $pdo->prepare("SELECT id, name, phone, email, role, time  FROM administrators WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);


// Continue with the rest of your HTML content
?>
<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AMS | Agents</title>
  <link rel="shortcut icon" type="image/png" href="http://localhost/ams/src/html/images/elp.png" />
  <link rel="stylesheet" href="../../assets/css/styles.min.css" />
  <!-- <link rel="stylesheet" href="../../assets/libs/datatable/datatables.net/css/dataTables.bootstrap5.min.css"> -->
  <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.0/css/bootstrap.min.css"> -->
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/1.0.4/css/dataTables.responsive.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/plug-ins/f2c75b7247b/integration/bootstrap/3/dataTables.bootstrap.css">
  <link rel="stylesheet" href="agent.css">
</head>

<body>
  <!--  Body Wrapper -->
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
    data-sidebar-position="fixed" data-header-position="fixed">
    <!-- Sidebar Start -->
    <?php include '../aside.php'; ?>
    <!--  Sidebar End -->
    <!--  Main wrapper -->
    <div class="body-wrapper">
      <!--  Header Start -->
      <?php include '../header.php'; ?>
      <!--  Header End -->
      <div class="body-wrappermm">
        <div class="container-fluid">
          <br><br><br><br>
          <div class="card bg-info-subtle shadow-none position-relative overflow-hidden mb-4">
            <div class="card-body px-4 py-3">
              <div class="row align-items-center">
                <div class="col-9">
                  <h4 class="fw-semibold mb-8">Agents</h4>
                  <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                      <li class="breadcrumb-item" aria-current="page">Floats  | Commissions</li>
                    </ol>
                  </nav>
                </div>
                <div class="col-3">
                  <div class="text-center mb-n5">
                    <img
                      src="../assets/images/breadcrumb/ChatBc.png"
                      alt=""
                      class="img-fluid mb-n4"
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="datatables">
            <!-- Column rendering -->
            <div class="row">
              <div class="col-12">
                <!-- ---------------------
                            start Column rendering
                        ---------------- -->
                <div class="card">
                  <div class="card-body">
                    <div class="mb-2">
                      <h5 class="mb-0">List of all agents</h5>
                    </div>
                    <div class="table-responsive">
                      <table id="index" class="table border table-striped table-bordered display text-nowrap"
                        style="width: 100%">
                        <thead>
                          <!-- start row -->
                          <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Location</th>
                            <th>TIN</th>
                            <!-- <th>Nature</th> -->
                            <th>Float</th>
                            <th>Phone</th>
                          </tr>
                          <!-- end row -->
                        </thead>
                        <tbody id="agentTableBody">
                          <!-- start row -->

                          <!-- end row -->
                        </tbody>
                        <tfoot>
                          <!-- start row -->
                          <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Location</th>
                            <th>TIN</th>
                            <!-- <th>Nature</th> -->
                            <th>Float</th>
                            <th>Phone</th>
                          </tr>
                          <!-- end row -->
                        </tfoot>
                      </table>
                    </div>
                  </div>
                </div>
                <!-- ---------------------
                            end Column rendering
                        ---------------- -->
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
    <script>
  function handleColorTheme(e) {
    $("html").attr("data-color-theme", e);
    $(e).prop("checked", !0);
  }
</script>
<button class="btn btn-primary p-3 rounded-circle d-flex align-items-center justify-content-center customizer-btn"
  type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample" aria-controls="offcanvasExample">
  <i class="icon ti ti-settings fs-7"></i>
</button>


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        ...
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Save changes</button>
      </div>
    </div>
  </div>
</div>

  </div>
  <div class="dark-transparent sidebartoggler"></div>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function() {
      $('#example').dataTable();
    } );
  </script>
  <script src="../../assets/libs/jquery/dist/jquery.min.js"></script>
  <script src="../../assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="../../assets/js/sidebarmenu.js"></script>
  <script src="../../assets/js/app.min.js"></script>
  <script src="../../assets/libs/apexcharts/dist/apexcharts.min.js"></script>
  <script src="../../assets/libs/simplebar/dist/simplebar.js"></script>
  <script src="../../assets/js/dashboard.js"></script>
  <div class="dark-transparent sidebartoggler"></div>
  <!-- Import Js Files -->
  <script src="agents.js" charset="utf-8"></script>

  <script src="../../assets/libs/jquery/dist/jquery.min.js"></script>
  <script src="../../assets/js/app.min.js"></script>
  <script src="../../assets/js/app.init.js"></script>
  <script src="../../assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="../../assets/libs/simplebar/dist/simplebar.min.js"></script>

  <script src="../../assets/js/sidebarmenu.js"></script>
  <script src="../../assets/js/theme.js"></script>

  <script src="https://cdn.datatables.net/v/bs5/jq-3.6.0/jszip-2.5.0/dt-1.13.1/b-2.3.3/b-html5-2.3.3/b-print-2.3.3/fh-3.3.1/r-2.4.0/sb-1.4.0/datatables.min.js" charset="utf-8"></script>
  <script type="text/javascript">
    $('table').DataTable();
  </script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js" charset="utf-8"></script>
  <script src="https://cdn.datatables.net/1.10.5/js/jquery.dataTables.min.js" charset="utf-8"></script>
  <script src="https://cdn.datatables.net/plug-ins/f2c75b7247b/integration/bootstrap/3/dataTables.bootstrap.js" charset="utf-8"></script>
  <script src="https://cdn.datatables.net/responsive/1.0.4/js/dataTables.responsive.js" charset="utf-8"></script>
  <!-- <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.flash.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>
  <script src="../../assets/libs/datatable/datatables.net/js/jquery.dataTables.min.js"></script>
  <script src="../../assets/libs/datatable/datatable-advanced.init.js"></script> -->
</body>

</html>
