function updateAgentData() {
    var xhr = new XMLHttpRequest();

    // Handle errors
    xhr.onerror = function() {
        console.error("Error fetching data");
    };

    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4) {
            if (xhr.status == 200) {
                var agents = JSON.parse(xhr.responseText);
                displayAgentData(agents);
            } else {
                console.error("Failed to fetch data. Status: " + xhr.status);
            }
        }
    };

    xhr.open("GET", "in.php", true);
    xhr.send();
}

function displayAgentData(agents) {
    var tableBody = document.getElementById("agentTableBody");
    tableBody.innerHTML = ''; // Clear existing data

    agents.forEach(function(agent) {
        var name = agent.fname + ' ' + agent.lname;
        var location = agent.region + ', ' + agent.mtaa;
        var float = '0';

        var row = document.createElement('tr');
        row.innerHTML = `
            <td  style='text-transform:capitalize'><a data-bs-toggle='modal' data-bs-target='#exampleModal'>${name}</a></td>
            <td>${agent.code}</td>
            <td>${location}</td>
            <td>${agent.tin}</td>
            <td>${agent.phone}</td>
            <td>${float}</td>
        `;

        tableBody.appendChild(row);
    });
}

// Fetch and update data every 5 seconds (adjust as needed)
setInterval(updateAgentData, 1000);
