<?php
session_start();

// Check if the user is not logged in
if (!isset($_SESSION['user_id'])) {
    // Redirect to the login page or another appropriate action
    header('Location: ../account'); // Assuming "/login" is the correct path
    exit();
}

require_once('../db.php');

// Fetch user information based on the user_id stored in the session
$user_id = $_SESSION['user_id'];

// Use a prepared statement to retrieve user data
$stmt = $pdo->prepare("SELECT id, code, fname, lname, region, mtaa, tin, qr, phone, time  FROM agents WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);


// Continue with the rest of your HTML content
?>
<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $user['fname'].' '.$user['lname'] ?> | Tangazo la wakala</title>
  <link rel="shortcut icon" type="image/png" href="../assets/images/logos/favicon.png" />
  <link rel="stylesheet" href="../../assets/css/styles.min.css" />
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
  <style>


     /* Set a fixed width for the div */
     #screenshotContent {
       width: 1000px; /* Adjust the width as needed */
       margin: 0 auto; /* Center the div */
       background-color: #004AAD; /* Set the background color */
     }
   </style>
</head>

<body>
  <!--  Body Wrapper -->
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
    data-sidebar-position="fixed" data-header-position="fixed">
    <!-- Sidebar Start -->
    <?php include '../asidenav.php'; ?>
    <!--  Sidebar End -->
    <!--  Main wrapper -->
    <div class="body-wrapper">
      <!--  Header Start -->
      <header class="app-header">
        <nav class="navbar navbar-expand-lg navbar-light">
          <ul class="navbar-nav">
            <li class="nav-item d-block d-xl-none">
              <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse" href="javascript:void(0)">
                <i class="ti ti-menu-2"></i>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link nav-icon-hover" href="http://localhost/ams/src/html/home">
                <i class="ti ti-home"></i>
                <!-- <div class="notification bg-primary rounded-circle"></div> -->
              </a>
            </li>
          </ul>
          <div class="navbar-collapse justify-content-end px-0" id="navbarNav">
            <ul class="navbar-nav flex-row ms-auto align-items-center justify-content-end">
              <a  id="screenshotButton"  class="btn text-white" style="background-color: #004AAD">
                <span>
                  <i class="ti ti-download"></i>
                </span>
                Download Tangazo
              </a>
            </ul>
          </div>
        </nav>
      </header>
      <!--  Header End -->
      <div class="container-fluid">
        <div class="container-fluidmm">
          <!-- <h5 class="card-title fw-semibold mb-4">Taarifa za Usajili</h5> -->
          <div id="screenshotContent" style="background-color: #004AAD " class="card">
            <div class="card-body">
              <div class="mb-3 row">
                <div class="col-lg-6 offset-lg-3">
                  <div class="row  mt-4 mb-4">
                    <div class="col-12">
                      <div class="p-1 text-center">
                        <a href="./index.html" class="text-nowrap logo-img">
                          <img src="http://localhost/ams/src/html/images/epl.png" style="border-radius: 15px" width="210" alt="" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <br>
                  <div class="mb-3 text-center">
                    <img src="../wakala/qrcodes/<?php echo $user['qr'] ?>" class="img-fluid" style="width: 500px; border-radius: 14px" alt="">
                  </div>
                </div>
              </div>
              <div class="row p-2 mt-4">
                <div class="text-center bg-white p-3" style="border-radius: 10px">
                  <h1 class="p-2"><?php echo $user['fname'].' '.$user['lname'] ?></h1>
                </div>
              </div>
              <div class="row p-2 mt-4">
                <div class="text-center bg-white p-3" style="border-radius: 10px">
                  <h1 class="p-2"><?php echo $user['code'] ?></h1>
                </div>
              </div>
              <div class="row p-2 mt-4">
                <div class="text-center p-3" style="border-radius: 10px">
                  <h1 class="p-2 text-white">AU PIGA <span style="font-weight: bolder">*150*40#</span> KUTOA PESA</h1>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    // Add a click event listener to the screenshot button
    document.getElementById("screenshotButton").addEventListener("click", function() {
      // Get the div element to take a screenshot
      var divToScreenshot = document.getElementById("screenshotContent");

      // Use html2canvas to take a screenshot
      html2canvas(divToScreenshot).then(function(canvas) {
        // Convert the canvas to a blob
        canvas.toBlob(function(blob) {
          // Create a download link for the blob
          var link = document.createElement("a");
          link.href = URL.createObjectURL(blob);
          link.download = "elpesawakala_tangazo.png";

          // Simulate a click on the link to trigger the download
          link.click();

          // Remove the link element
          URL.revokeObjectURL(link.href);
        }, "image/png");
      });
    });
  </script>
  <script src="../../assets/libs/jquery/dist/jquery.min.js"></script>
  <script src="../../assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="../../assets/js/sidebarmenu.js"></script>
  <script src="../../assets/js/app.min.js"></script>
  <script src="../../assets/libs/simplebar/dist/simplebar.js"></script>
</body>

</html>
