
<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Unipesa Manager | AMS</title>
  <link rel="shortcut icon" type="image/png" href="http://localhost/ams/src/html/images/elp.png" />
  <link rel="stylesheet" href="../assets/css/styles.min.css" />
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>
  <!--  Body Wrapper -->
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
    data-sidebar-position="fixed" data-header-position="fixed">
    <!-- Sidebar Start -->
    <?php include 'aside.php'; ?>
    <!--  Sidebar End -->
    <!--  Main wrapper -->
    <div class="body-wrapper">
      <!--  Header Start -->
      <?php include 'header.php'; ?>
      <!--  Header End -->
      <div class="container-fluid">
        <div class="row">
            <div class="col-lg-4">
                <div class="card overflow-hidden bg-dark" style="background-color: bla; border-radius: 18px">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 text-white fw-semibold">Agents acquired</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold mb-3 text-white">58,000</h4>
                        <div class="d-flex align-items-center mb-3">
                          <span
                            class="me-1 rounded-circle bg-light-success round-20 d-flex align-items-center justify-content-center">
                            <i class="ti ti-arrow-up-left text-success"></i>
                          </span>
                          <p class="text-dark me-1 fs-3 mb-0 text-white">+9%</p>
                          <p class="fs-3 mb-0 text-white">last month</p>
                        </div>
                        <div class="d-flex align-items-center">
                          <div class="me-4">
                            <span class="round-8 bg-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2 text-white">2023</span>
                          </div>
                          <div>
                            <span class="round-8 bg-light-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2 text-white">2023</span>
                          </div>
                        </div>
                      </div>
                      <div class="col-4">
                        <div class="d-flex justify-content-center">
                          <div id="breakup"></div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>    
            </div>
            <div class="col-lg-4">
                <div class="card overflow-hidden" style="border-radius: 18px">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 fw-semibold">Float Balance</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold mb-3">36,358,000</h4>
                        <div class="d-flex align-items-center mb-3">
                          <span
                            class="me-1 rounded-circle bg-light-success round-20 d-flex align-items-center justify-content-center">
                            <i class="ti ti-arrow-up-left text-success"></i>
                          </span>
                          <p class="text-dark me-1 fs-3 mb-0">+9%</p>
                          <p class="fs-3 mb-0">last month</p>
                        </div>
                        <div class="d-flex align-items-center">
                          <div class="me-4">
                            <span class="round-8 bg-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">2023</span>
                          </div>
                          <div>
                            <span class="round-8 bg-light-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">2023</span>
                          </div>
                        </div>
                      </div>
                      <div class="col-4">
                        <div class="d-flex justify-content-center">
                          <div id="breakup"></div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>    
            </div>
            <div class="col-lg-4">
                <div class="card overflow-hidden" style="border-radius: 18px">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 fw-semibold">Processed Transactions</h5>
                    <div class="row align-items-center">
                      <div class="col-12">
                        <h4 class="fw-semibold mb-3">86,358,000</h4>
                        <div class="d-flex align-items-center mb-3">
                          <span
                            class="me-1 rounded-circle bg-light-success round-20 d-flex align-items-center justify-content-center">
                            <i class="ti ti-arrow-up-left text-success"></i>
                          </span>
                          <p class="text-dark me-1 fs-3 mb-0">+9%</p>
                          <p class="fs-3 mb-0">last month</p>
                        </div>
                        <div class="d-flex align-items-center">
                          <div class="me-4">
                            <span class="round-8 bg-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">12,00,000</span>
                          </div>
                          <div>
                            <span class="round-8 bg-light-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">20,235,000</span>
                          </div>
                        </div>
                      </div>
                      <!--<div class="col-4">-->
                      <!--  <div class="d-flex justify-content-center">-->
                      <!--    <div id="breakup"></div>-->
                      <!--  </div>-->
                      <!--</div>-->
                    </div>
                  </div>
                </div>    
            </div>       
        </div>
        <div class="row">
            <div class="col-lg-4">
                <div class="card overflow-hidden bg-primary" style="background-color: bla; border-radius: 18px ">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 text-white fw-semibold">SMS balance</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold text-white">58,000</h4>
                      </div>
                    </div>
                  </div>
                </div>    
            </div>
            <div class="col-lg-4">
                <div class="card overflow-hidden bg-success" style="background-color: bla; border-radius: 18px">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 text-white fw-semibold">Voucher balance</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold text-white">108,000</h4>
                      </div>
                    </div>
                  </div>
                </div>    
            </div>
            <div class="col-lg-4">
                <div class="card overflow-hidden bg-warning" style="background-color: bla; border-radius: 18px">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 text-white fw-semibold">API calls</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold text-white">320,000</h4>
                      </div>
                    </div>
                  </div>
                </div>    
            </div>      
        </div>        
        <!--  Row 1 -->
        <div class="row">
          <div class="col-lg-8 d-flex align-items-strech">
            <div class="card w-100">
              <div class="card-body">
                <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                  <div class="mb-3 mb-sm-0">
                    <h5 class="card-title fw-semibold">Transactions Overview</h5>
                  </div>
                  <div>
                    <select class="form-select">
                      <option value="2025">2025</option>
                    </select>
                  </div>
                </div>
                <canvas id="myChart" width="400" height="200"></canvas>
                <!-- <div id="chart"></div> -->
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="row">
              <div class="col-lg-12">
                <!-- Yearly Breakup -->
                <div class="card overflow-hidden">
                  <div class="card-body p-4">
                    <h5 class="card-title mb-9 fw-semibold">Monthly Transactions</h5>
                    <div class="row align-items-center">
                      <div class="col-8">
                        <h4 class="fw-semibold mb-3">36,358,000</h4>
                        <div class="d-flex align-items-center mb-3">
                          <span
                            class="me-1 rounded-circle bg-light-success round-20 d-flex align-items-center justify-content-center">
                            <i class="ti ti-arrow-up-left text-success"></i>
                          </span>
                          <p class="text-dark me-1 fs-3 mb-0">+9%</p>
                          <p class="fs-3 mb-0">last month</p>
                        </div>
                        <div class="d-flex align-items-center">
                          <div class="me-4">
                            <span class="round-8 bg-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">2023</span>
                          </div>
                          <div>
                            <span class="round-8 bg-light-primary rounded-circle me-2 d-inline-block"></span>
                            <span class="fs-2">2023</span>
                          </div>
                        </div>
                      </div>
                      <div class="col-4">
                        <div class="d-flex justify-content-center">
                          <div id="breakup"></div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-12">
                <!-- Monthly Earnings -->
                <div class="card">
                  <div class="card-body">
                    <div class="row alig n-items-start">
                      <div class="col-8">
                        <h5 class="card-title mb-9 fw-semibold"> Monthly Commissions </h5>
                        <h4 class="fw-semibold mb-3">TSH 6,820,000</h4>
                        <div class="d-flex align-items-center pb-1">
                          <span
                            class="me-2 rounded-circle bg-light-danger round-20 d-flex align-items-center justify-content-center">
                            <i class="ti ti-arrow-down-right text-danger"></i>
                          </span>
                          <p class="text-dark me-1 fs-3 mb-0">+9%</p>
                          <p class="fs-3 mb-0">last month</p>
                        </div>
                      </div>
                      <div class="col-4">
                        <div class="d-flex justify-content-end">
                          <div
                            class="text-white bg-secondary rounded-circle p-6 d-flex align-items-center justify-content-center">
                            <i class="ti ti-currency-dollar fs-6"></i>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div id="earning"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-12 d-flex align-items-stretch">
            <div class="card w-100">
              <div class="card-body p-4">
                <h5 class="card-title fw-semibold mb-4">Transaction volume by MNO</h5>
                <div class="table-responsive">
                  <table class="table text-nowrap mb-0 align-middle">
                    <thead class="text-dark fs-4">
                      <tr>
                        <th class="border-bottom-0">
                          <h6 class="fw-semibold mb-0">MNO</h6>
                        </th>
                        <th class="border-bottom-0">
                          <h6 class="fw-semibold mb-0">Volume (%)</h6>
                        </th>
                        <th class="border-bottom-0">
                          <h6 class="fw-semibold mb-0">Deposits</h6>
                        </th>
                        <th class="border-bottom-0">
                          <h6 class="fw-semibold mb-0">Withdrawals</h6>
                        </th>
                        <th class="border-bottom-0">
                          <h6 class="fw-semibold mb-0">Margin</h6>
                        </th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td class="border-bottom-0">
                            <h6 class="fw-semibold mb-1">Airtel Money</h6>
                        </td>
                        <td class="border-bottom-0">
                            <h6 class="fw-semibold mb-1">34%</h6>
                        </td>
                        <td class="border-bottom-0">
                          <p class="mb-0 fw-normal">18,005,000</p>
                        </td>
                        <td class="border-bottom-0">
                          <p class="mb-0 fw-normal">28,005,000</p>
                        </td>
                        <td class="border-bottom-0">
                          <h6 class="fw-normal mb-0">3,231,000</h6>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="py-6 px-6 text-center">
          <p class="mb-0 fs-4">Under copyrights of elpesa <?php echo date('Y') ?></p>
        </div>
      </div>
    </div>
  </div>
<script type="text/javascript">
  document.addEventListener('DOMContentLoaded', function () {
    var data = {
      labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
      datasets: [
        {
          label: 'Deposits',
          backgroundColor: 'rgba(75, 192, 192, 0.2)', // Lighter fill color
          borderColor: 'rgba(75, 192, 192, 1)',
          borderWidth: 3,
          pointBackgroundColor: 'rgba(75, 192, 192, 1)', // Custom point color
          pointRadius: 5, // Larger points for better visibility
          pointHoverRadius: 7, // Points expand on hover
          data: [1000, 1500, 800, 1200, 2000, 1800, 2500, 3000, 1500, 1200, 2000, 2500],
          fill: true, // Fills the area under the line
          tension: 0.4 // Smooth curve (0 = straight, 1 = very curved)
        },
        {
          label: 'Withdrawals',
          backgroundColor: 'rgba(255, 99, 132, 0.2)',
          borderColor: 'rgba(255, 99, 132, 1)',
          borderWidth: 3,
          pointBackgroundColor: 'rgba(255, 99, 132, 1)',
          pointRadius: 5,
          pointHoverRadius: 7,
          data: [500, 1000, 300, 800, 1200, 1000, 1500, 2000, 800, 500, 1200, 1500],
          fill: true,
          tension: 0.4 // Same curve smoothness
        },
      ],
    };

    var options = {
      responsive: true,
      plugins: {
        legend: {
          position: 'top', // Places the legend at the top
        },
        tooltip: {
          mode: 'index', // Shows all datasets on hover
          intersect: false
        }
      },
      scales: {
        x: {
          grid: {
            display: false // Removes vertical grid lines
          }
        },
        y: {
          beginAtZero: true // Starts Y-axis at 0
        }
      },
      interaction: {
        mode: 'nearest', // Improves hover behavior
        axis: 'x',
        intersect: false
      }
    };

    var ctx = document.getElementById('myChart').getContext('2d');
    var myChart = new Chart(ctx, {
      type: 'line',
      data: data,
      options: options
    });
  });
</script>
  <script src="../assets/libs/jquery/dist/jquery.min.js"></script>
  <script src="../assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/sidebarmenu.js"></script>
  <script src="../assets/js/app.min.js"></script>
  <script src="../assets/libs/apexcharts/dist/apexcharts.min.js"></script>
  <script src="../assets/libs/simplebar/dist/simplebar.js"></script>
  <script src="../assets/js/dashboard.js"></script>
</body>

</html>
