<?php
session_start();
require_once('db.php'); // Include your database connection script

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = filter_input(INPUT_POST, 'code', FILTER_SANITIZE_STRING);
    $password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);

    // Check user credentials
    $stmt = $pdo->prepare("SELECT id, code, password FROM agents WHERE code = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        // Successful login
        $_SESSION['user_id'] = $user['id'];
        header('Location: ../wakala'); // Assuming "/home" is the correct path
        exit();
    } else {
        // Failed login
        echo 'Invalid username or password';
        // Add more debugging info here if needed
    }
}
?>
